// calculate the truth by simulating large dataset
// Note no censoring included (no need as it is random)

// True values written as globals in scenario specific do files


// change to folder where this file is stored.
cd "C:\TSD_simulation\Generate_Truths"

// background rates
include ../Scenario_Parameters/background_mortality_rate_gompertz.do

set seed 89234579

// Different Scenarios
foreach scen in 1 2 3 4 {
	// Low and medium survival
	foreach S in 1 2 {
	// Different frailty effects
		foreach F in 1 2 {
			include ../Scenario_Parameters/Scenario`scen'_S`S'_F`F'.do
		// dataset counter
			clear
			qui set obs 10000000
			gen double age = rnormal(60,6)
			gen double z = rnormal(0,1)
				
			// disease-specific mortality
			local pmixopt = cond(`scen'==3,"pmix(`pmix')","")
			local mixture = cond(`scen'==3,"mixture","")
			qui survsim td dd, dist(`dist') lambda(`lambda1' `lambda2') gamma(`gamma1' `gamma2') `pmixopt' maxt(80) cov(z `frailty_beta') `mixture'
			// cure model
			if `scen' == 4 {
				gen byte cure = runiform()<=`pi'
				replace td = 80 if cure
			}
				
			// other cause mortality
			// attained age as time-scale so incorporate S(agediag).
			gen double S0 = exp(-`lambda_gomp'/`gamma_gomp' *(exp(`gamma_gomp'*age) - 1))
			gen double lnU = ln(runiform()*S0)
				
			// generate from gompertz and change back to time from diagnosis scale
			gen double toth = ln(-lnU*`gamma_gomp'/`lambda_gomp' + 1)/`gamma_gomp' - age
			qui replace toth = 80 if toth>80
				
			// censoring
			//survsim tc dc, dist(exp) lambda(0.1) maxt(3)
				
			// combine disease, other and censoring times
			gen double t = min(td,toth)
			gen double d = cond(td<80 | toth<80,1,0)
			
			// obtain true rmst (3 years) and mean survival
			stset t d
			sts gen st = s
			integ st t if t<=3
			local true_rmst3 `r(integral)'
			integ st t 
			local true_meansurv `r(integral)'
			file open truth using ../Scenario_parameters/Scenario`scen'_S`S'_F`F'_Truth.do, write replace
			file write truth "// Scenario`scen'_S`S'_F`F'_Truth" _newline ////
							 "global true_rmst3 `true_rmst3'" _newline ///
                             "global true_meansurv `true_meansurv'" _newline
			file close truth
		}
	}
} 

